/**
* \file: UspiTouchInput.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Carplay - USPI Touch Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
* \author: D. Devarasu /RBEI/ECF3 / dhanasekaran.d@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <string.h>
#include <adit_logging.h>
#include <dipo_macros.h>
#include "UspiTouchInput.h"
#include "HIDDigitizer.h"
#include "UspiTouchInputImpl.h"

LOG_IMPORT_CONTEXT(cplay_utouch);

namespace adit { namespace carplay
{

using namespace std;

// currently touch only supports 1 session, in case of overlap kill the old one
UspiTouchInput* UspiTouchInput::current = nullptr;

UspiTouchInput::UspiTouchInput()
{
    impl = move(std::unique_ptr<UspiTouchInputImpl>(new UspiTouchInputImpl()));
    if (current != nullptr)
    {
        LOG_ERROR((cplay_utouch, "old touch session still active; force exit"));
        current->release();
    }
    current = this;
}

UspiTouchInput::~UspiTouchInput()
{
    current = nullptr;
}

bool UspiTouchInput::Initialize(const IConfiguration& inConfig, IInputReceiver& inReceiver, SessionId inSessionId)
{
    return impl->Initialize(inConfig, inReceiver, inSessionId);
}

void UspiTouchInput::release()
{
    dipo_safe_delete(current);
}

} } // namespace adit { namespace carplay
